

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Manufacture</h5>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <!-- Tabs -->
                        <ul class="nav nav-tabs" id="manufactureTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="assembled-tab" data-bs-toggle="tab"
                                    data-bs-target="#assembled" type="button" role="tab" aria-controls="assembled"
                                    aria-selected="false">
                                    Assembled Item
                                </button>
                            </li>

                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="bom-tab" data-bs-toggle="tab" data-bs-target="#bom"
                                    type="button" role="tab" aria-controls="bom" aria-selected="true">
                                    Bill Of Material
                                </button>
                            </li>
                        </ul>

                        <div class="tab-content mt-3" id="manufactureTabsContent">
                            <div class="tab-pane fade show active" id="assembled" role="tabpanel"
                                aria-labelledby="assembled-tab">
                                <div class="d-flex justify-content-between">
                                    <h5 class="p-2">Assembled Item</h5>
                                    <a href="<?php echo e(route('manufacture-assemble-add')); ?>" class="btn btn-primary btn-sm">
                                        Assemble Item</a>
                                </div>
                                <div class="table-responsive">
                                    <table class="table" id="myTable2">
                                        <thead>
                                            <tr>
                                                <th class="text-center">#</th>
                                                <th class="text-center">Assembled Date</th>
                                                <th class="text-center">Assembled Item</th>
                                                <th class="text-center">Assembled Qty</th>
                                                <th class="text-center">Unit Cost</th>
                                                <th class="text-center">Total Amount</th>
                                                <th class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $assembledItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-center"><?php echo e($loop->iteration); ?></td>
                                                    <td class="text-center"><?php echo e($item->assemble_date ?? ''); ?></td>
                                                    <td class="text-center"><?php echo e($item->bom->assemble_item ?? ''); ?></td>
                                                    <td class="text-center"><?php echo e($item->assembled_qty ?? ''); ?></td>
                                                    <td class="text-center">₹
                                                        <?php echo e(number_format($item->per_unit_cost ?? '', 2)); ?>

                                                    </td>
                                                    <td class="text-center">₹
                                                        <?php echo e(number_format($item->total_amount ?? '', 2)); ?>

                                                    </td>
                                                    <td class="text-center">
                                                        <a href="<?php echo e(route('manufacture-assemble-view', ['id' => $item->id])); ?>">
                                                            <i class="fa-solid fa-eye text-info me-2"></i></a>
                                                        <a href="#" class="delete-assembled"
                                                            data-url="<?php echo e(route('manufacture-assemble-delete', ['id' => $item->id])); ?>">
                                                            <i class="fa fa-trash text-danger me-2"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="bom" role="tabpanel" aria-labelledby="bom-tab">
                                <div class="d-flex justify-content-between">
                                    <h5 class="p-2">Bill Of Material</h5>
                                    <a href="<?php echo e(route('manufacture-bom-add')); ?>" class="btn btn-primary btn-sm">+ Add BOM</a>
                                </div>
                                <div class="table-responsive">
                                    <table class="table" id="myTable3">
                                        <thead>
                                            <tr>
                                                <th class="text-center">#</th>
                                                <th class="text-center">Assembled Item</th>
                                                <th class="text-center">Total Amount</th>
                                                <th class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $bom; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-center"><?php echo e($loop->iteration); ?></td>
                                                    <td class="text-center"><?php echo e($item->assemble_item ?? ''); ?></td>
                                                    <td class="text-center">₹
                                                        <?php echo e(number_format($item->bomItems->sum('amount') ?? '', 2)); ?>

                                                    </td>
                                                    <td class="text-center">
                                                        <a href="<?php echo e(route('manufacture-bom-edit', ['id' => $item->id])); ?>"> <i
                                                                class="fa-solid fa-pen-to-square text-success me-2"></i></a>
                                                        <a href="#" class="delete-bom"
                                                            data-url="<?php echo e(route('manufacture-bom-delete', ['id' => $item->id])); ?>">
                                                            <i class="fa fa-trash text-danger me-2"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function () {
            $('#myTable2, #myTable3').DataTable({
                order: []
            });

            // BOM Delete confirmation
            $(document).on('click', '.delete-bom', function (e) {
                e.preventDefault();
                const url = $(this).data('url');
                Swal.fire({
                    title: 'Are you sure?',
                    text: "This will delete the BOM permanently!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = url;
                    }
                });
            });

            // Assembled Item Delete confirmation
            $(document).on('click', '.delete-assembled', function (e) {
                e.preventDefault();
                const url = $(this).data('url');
                Swal.fire({
                    title: 'Are you sure?',
                    text: "This will delete the assembled item and adjust stock!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = url;
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/manufacture/index.blade.php ENDPATH**/ ?>